/*
 * Decompiled with CFR 0.152.
 */
package tech.feldman.betterrecords.network;

import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.feldman.betterrecords.api.sound.Sound;
import tech.feldman.betterrecords.block.tile.TileFrequencyTuner;
import tech.feldman.betterrecords.block.tile.TileRecordEtcher;
import tech.feldman.betterrecords.extensions.IMessageExtensionsKt;
import tech.feldman.betterrecords.helper.nbt.ColorableSoundHolderHelperKt;
import tech.feldman.betterrecords.helper.nbt.SoundHolderHelperKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0017\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001#BC\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016R\u001a\u0010\n\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\t\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0011\"\u0004\b\u001b\u0010\u0013R\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\r\"\u0004\b\u001d\u0010\u000f\u00a8\u0006$"}, d2={"Ltech/feldman/betterrecords/network/PacketURLWrite;", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;", "pos", "Lnet/minecraft/util/math/BlockPos;", "size", "", "name", "", "url", "color", "author", "(Lnet/minecraft/util/math/BlockPos;ILjava/lang/String;Ljava/lang/String;ILjava/lang/String;)V", "getAuthor", "()Ljava/lang/String;", "setAuthor", "(Ljava/lang/String;)V", "getColor", "()I", "setColor", "(I)V", "getName", "setName", "getPos", "()Lnet/minecraft/util/math/BlockPos;", "setPos", "(Lnet/minecraft/util/math/BlockPos;)V", "getSize", "setSize", "getUrl", "setUrl", "fromBytes", "", "buf", "Lio/netty/buffer/ByteBuf;", "toBytes", "Handler", "BetterRecords"})
public final class PacketURLWrite
implements IMessage {
    @NotNull
    private BlockPos pos;
    private int size;
    @NotNull
    private String name;
    @NotNull
    private String url;
    private int color;
    @NotNull
    private String author;

    public void toBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        IMessageExtensionsKt.writeBlockPos(this, buf, this.pos);
        buf.writeInt(this.size);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.url);
        buf.writeInt(this.color);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.author);
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        this.pos = IMessageExtensionsKt.readBlockPos(this, buf);
        this.size = buf.readInt();
        String string = ByteBufUtils.readUTF8String((ByteBuf)buf);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ByteBufUtils.readUTF8String(buf)");
        this.name = string;
        String string2 = ByteBufUtils.readUTF8String((ByteBuf)buf);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ByteBufUtils.readUTF8String(buf)");
        this.url = string2;
        this.color = buf.readInt();
        String string3 = ByteBufUtils.readUTF8String((ByteBuf)buf);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"ByteBufUtils.readUTF8String(buf)");
        this.author = string3;
    }

    @NotNull
    public final BlockPos getPos() {
        return this.pos;
    }

    public final void setPos(@NotNull BlockPos blockPos) {
        Intrinsics.checkParameterIsNotNull((Object)blockPos, (String)"<set-?>");
        this.pos = blockPos;
    }

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int n) {
        this.size = n;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    public final void setUrl(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.url = string;
    }

    public final int getColor() {
        return this.color;
    }

    public final void setColor(int n) {
        this.color = n;
    }

    @NotNull
    public final String getAuthor() {
        return this.author;
    }

    public final void setAuthor(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.author = string;
    }

    @JvmOverloads
    public PacketURLWrite(@NotNull BlockPos pos, int size, @NotNull String name, @NotNull String url, int color2, @NotNull String author) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)author, (String)"author");
        this.pos = pos;
        this.size = size;
        this.name = name;
        this.url = url;
        this.color = color2;
        this.author = author;
    }

    @JvmOverloads
    public /* synthetic */ PacketURLWrite(BlockPos blockPos, int n, String string, String string2, int n2, String string3, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            blockPos = new BlockPos(0, 0, 0);
        }
        if ((n3 & 2) != 0) {
            n = -1;
        }
        if ((n3 & 4) != 0) {
            string = "";
        }
        if ((n3 & 8) != 0) {
            string2 = "";
        }
        if ((n3 & 0x10) != 0) {
            n2 = -1;
        }
        if ((n3 & 0x20) != 0) {
            string3 = "";
        }
        this(blockPos, n, string, string2, n2, string3);
    }

    @JvmOverloads
    public PacketURLWrite(@NotNull BlockPos pos, int size, @NotNull String name, @NotNull String url, int color2) {
        this(pos, size, name, url, color2, null, 32, null);
    }

    @JvmOverloads
    public PacketURLWrite(@NotNull BlockPos pos, int size, @NotNull String name, @NotNull String url) {
        this(pos, size, name, url, 0, null, 48, null);
    }

    @JvmOverloads
    public PacketURLWrite(@NotNull BlockPos pos, int size, @NotNull String name) {
        this(pos, size, name, null, 0, null, 56, null);
    }

    @JvmOverloads
    public PacketURLWrite(@NotNull BlockPos pos, int size) {
        this(pos, size, null, null, 0, null, 60, null);
    }

    @JvmOverloads
    public PacketURLWrite(@NotNull BlockPos pos) {
        this(pos, 0, null, null, 0, null, 62, null);
    }

    @JvmOverloads
    public PacketURLWrite() {
        this(null, 0, null, null, 0, null, 63, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Ltech/feldman/betterrecords/network/PacketURLWrite$Handler;", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessageHandler;", "Ltech/feldman/betterrecords/network/PacketURLWrite;", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;", "()V", "onMessage", "message", "ctx", "Lnet/minecraftforge/fml/common/network/simpleimpl/MessageContext;", "BetterRecords"})
    public static final class Handler
    implements IMessageHandler<PacketURLWrite, IMessage> {
        @Nullable
        public IMessage onMessage(@NotNull PacketURLWrite message, @NotNull MessageContext ctx) {
            ItemStack itemStack;
            TileEntity te;
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            TileEntity tileEntity = te = player.field_70170_p.func_175625_s(message.getPos());
            if (tileEntity instanceof TileRecordEtcher) {
                itemStack = ((TileRecordEtcher)te).getRecord();
            } else if (tileEntity instanceof TileFrequencyTuner) {
                itemStack = ((TileFrequencyTuner)te).getCrystal();
            } else {
                return null;
            }
            ItemStack itemStack2 = itemStack;
            SoundHolderHelperKt.addSound(itemStack2, new Sound(message.getUrl(), message.getName(), message.getSize(), message.getAuthor()));
            ColorableSoundHolderHelperKt.setColor(itemStack2, message.getColor());
            return null;
        }
    }
}

